/** @file   sentrygun.h
 * @brief   Declarations of SentryGun class.
 * @version $Revision: 1.1.1.1 $
 * @date    $Date: 2006/01/21 23:02:42 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_SENTRYGUN_H
#define H_WWW_SENTRYGUN_H

#include "alien.h"


namespace WeWantWar {


/** @class  SentryGun
 * @brief   Immobile objects that shoots player.
 * @author  Tomi Lamminsaari
 *
 * SentryGuns are machineguns that shoot player when he comes in sight. They
 * can shoot fireballs, machinegun bullets or operate as a flamethrower.
 */
class SentryGun : public Alien
{
public:

  ///
  /// Static members and methods
  /// ==========================
  
  
  /** Possible bullet types this SentryGun shoots
   */
  enum GunType {
    /** Shoots fireballs */
    T_FIREBALL,
    /** Shoots with flamethrower */
    T_FLAMETHROWER,
    /** Shoots with machinegun */
    T_MACHINEGUN
  };

  /** Index of the controlpoint that contains the coordinate of the gun nose */
  static const int GUN_CTRLPOINT_INDEX = 0;
  
  /** Index of the fireballgun pipe 1 */
  static const int FIREBALL_CTRLPOINT1_INDEX = 1;
  /** Index of the fireballgun pipe 2 */
  static const int FIREBALL_CTRLPOINT2_INDEX = 2;
  
  /** Reloading delay */
  static const int MACHINEGUN_RELOAD_DELAY = 3;
  /** Fireball gun delay */
  static const int FIREBALL_RELOAD_DELAY = 20;

  ///
  /// Constructors, destructor and operators
  /// ======================================

  /** Constructs new SentryGun
   * @param     t                 Type of the gun
   */
  SentryGun( GunType t );
  
  /** Destructor
   */
  virtual ~SentryGun();
  


  ///
  /// Methods
  /// =======

  /** Updates this object
   */
  virtual void update();
  
  /** Redraws this object.
   * @param     pQueue            Pointer redraw queue
   */
  virtual void redraw( RedrawQueue* pQueue );
  
  /** Makes some noise
   * @param     id                ID of the sound we should make.
   */
  virtual void makeSound( GameObject::SoundID id ) const;
  
  /** Kills this object.
   */
  virtual void kill();

  /** Handles the bullethits
   * @param     pB                Pointer to the bullet that hit us.
   * @return    <code>true</code> if we accept the bullethit.
   */
  virtual bool hitByBullet( Bullet* pB );



  ///
  /// Getter methods
  /// ==============
  
  /** Returns the type of this object.
   * @return    ObjectID::TYPE_SENTRYGUN
   */
  virtual ObjectID::Type objectType() const;

  /** Returns the type of this SentryGun.
   * @return    Either T_FIREBALL, T_FLAMETHROWER or T_MACHINEGUN
   */
  GunType gunType() const;
  

protected:

  /** Updates the machinegun
   */
  void updateMachinegun();
  
  /** Updates the fireball gun
   */
  void updateFireballgun();
  
  /** Sets the requesetd animation
   * @param     aAnimId           Id of the animation.
   */
  virtual void setCorrectAnimation( int aAnimId );
  
  /** Attacks the target.
   */
  virtual void attack();
  
  /** Shoots with machine gun
   */
  void shootMachineGun();
  
  /** Shoots with fireballs
   */
  void shootFireball();
  
  ///
  /// Members
  /// =======
  
  /** What kind of sentrygun this is. */
  GunType m_gunType;
  

private:

  /** Private methods **/
  
  SentryGun(const SentryGun& rO);
  SentryGun& operator = (const SentryGun& rO);
};

};  // end of namespace

#endif

/**
 * Version history
 * ===============
 * $Log: sentrygun.h,v $
 * Revision 1.1.1.1  2006/01/21 23:02:42  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:17:14+02  lamminsa
 * Initial revision
 *
 */
 
